'Project:NEC And Samsung IR Remote Control Decoder
'Bascom-Avr IDE [2.0.7.5]
'Microcontroller: Atemega8A
'Flash Used: 2624 bytes

'Author : Mahmood Alimohammadi
'Date:April 20, 2016
'*******************************************************************************

$regfile = "m8adef.dat"
$crystal = 4000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Rs = Portb.0 , E = Portb.1 , Db4 = Portb.2 , Db5 = Portb.3 , Db6 = Portb.4 , Db7 = Portb.5

Config Timer1 = Timer , Prescale = 8 , Clear Timer = 1      '4000000/8=500000
Config Int1 = Falling
Config Pind.3 = Input
Config Portc = Output

Stop Timer1
Enable Timer1
Enable Int1
Enable Interrupts

On Compare1a Counting
Enable Compare1a
Compare1a = 50 - 1                                          '500000/50=10000--1sec/10000=100usec

On Int1 Ir_receiver
'*******************************************************************************

Dim Count As Word
Dim Bitt As Byte
Dim Id As Byte
Dim Key As Byte
Dim Nec As Bit
Dim Nec1 As Bit
Dim Sam As Bit
Dim Sam1 As Bit
Dim Sam2 As Bit

Led1 Alias Portc.0
Led2 Alias Portc.1
'******************************************************************************8

Begin:
Cursor Off
Cls
Upperline
Lcd "NEC and Samsung"
Locate 2 , 5
Lcd "Decoder"
'*******************************************************************************

Main_program:
Do
If Sam1 = 1 Then
Cursor Off
Cls
Upperline
Lcd "Samsung Decoder"
Locate 2 , 1
Lcd "ID:" ; Id                                              'ID number is the address number of a device.
Locate 2 , 9
Lcd "KEY:" ; Key                                            'Key number is the command number of a key.
Sam1 = 0
End If

If Nec1 = 1 Then
Cursor Off
Cls
Locate 1 , 3
Lcd "NEC Decoder"
Locate 2 , 1
Lcd "ID:" ; Id
Locate 2 , 9
Lcd "KEY:" ; Key
Nec1 = 0
End If

If Id = 224 Then                                            'ID number must be the same as the ID number that the display shows.
If Key = 32 Then                                            'Key number must be the same as the Key number that the display shows.
Led1 = 1
Elseif Key = 160 Then
Led1 = 0
End If
End If
Waitms 100
Loop
End
'*******************************************************************************

Counting:
Select Case Count
Incr Count                                                  'One count=100us

Case Is >= 600                                              'Samsung message to be repeated at 60ms intervals
Count = 0
Sam = 0
Sam1 = 0
Sam2 = 0
Led2 = 0
Stop Timer1

Case Is >= 1100                                             'NEC message to be repeated at 110ms intervals
Count = 0
Nec = 0
Nec1 = 0
Led2 = 0
Sam2 = 0
Stop Timer1
End Select
Return
'*******************************************************************************

 Ir_receiver:

 Start Timer1

 Starting:
 Select Case Count

 Case 85 To 95                                              'Samsung Start Code =8.5ms to 9.5ms
 Id = 0
 Key = 0
 Sam = 1
 Sam1 = 1
 Sam2 = 0
 Led2 = 1

 Case 130 To 140                                            'NEC Start Code=13ms to 14ms
 Id = 0
 Key = 0
 Nec = 1
 Nec1 = 0
 Sam2 = 1

 Case 110 To 125                                            ' NEC repeat code=11ms to 12.5ms--power-saving feature
 Nec = 0
 Nec1 = 1
 Led2 = 1
 End Select

 If Sam2 = 1 And Nec = 0 Then
 Sam1 = 1
 Led2 = 1
 End If                                                     'Display Samsung Decoder and turn on LED2 with a key pressed.

 '******************************************************************************

 Logical_1:
 If Sam = 1 Then
 If Count > 18 And Count < 28 Then                          'Samsung Logical "1"=1.9ms to 2.7ms
 Incr Bitt

 Select Case Bitt
 Case 1 To 16                                               'Samsung Address=16 bits
 Id = Id * 2
 Id = Id + 1

 Case 17 To 24                                              'Samsung Command=8 bits
 Key = Key * 2
 Key = Key + 1
 End Select

 End If
 End If

'*******************************************************************************
 If Nec = 1 Then
 If Count > 18 And Count < 28 Then                          'NEC Logical "1"=1.9ms to 2.7ms
 Incr Bitt

 Select Case Bitt
 Case 1 To 16                                               'NEC Address=16 bits                                        '
 Id = Id * 2
 Id = Id + 1

 Case 17 To 32                                              'NEC Command=16 bits
 Key = Key * 2
 Key = Key + 1
 End Select

 End If
 End If

 '******************************************************************************

 Logical_0:
 If Sam = 1 Then
 If Count > 8 And Count < 16 Then                           'Samsung Logical "0"=0.9ms to 1.5ms
 Incr Bitt
 Select Case Bitt
 Case 1 To 16
 Id = Id * 2

 Case 17 To 24
 Key = Key * 2
 End Select

 End If
 End If
 '******************************************************************************

 If Nec = 1 Then
 If Count > 8 And Count < 16 Then                           'NEC Logical "0"=0.9ms to 1.5ms
 Incr Bitt
 Select Case Bitt
 Case 1 To 16
 Id = Id * 2

 Case 17 To 32
 Key = Key * 2
 End Select
 End If
 End If

 Count = 0

 '******************************************************************************

 Total_bits:
 If Sam = 1 Then
 Select Case Bitt
 Case Is = 24                                               'Samsung Address,16 bits+command,8 bits=24 bits
 Bitt = 0
 Sam = 0
 Stop Timer1
 End Select
 End If

 If Nec = 1 Then
 Select Case Bitt
 Case Is = 32                                               'NEC Address,16 bits+command,16 bits=32
 Bitt = 0
 Nec = 0
 Stop Timer1
 End Select
 End If
 Return



 '******************************************************************************
 '******************************************************************************